import pool from "../db.js";
import fs from "fs";
import path from "path";

export async function getVehicles(req, res) {
  try {
    const conn = await pool.getConnection();
    const [rows] = await conn.query("SELECT * FROM vehicles");
    res.json(rows);
  } catch (err) {
    console.error("❌ Error getting vehicles:", err);
    res.status(500).json({ message: "Server error" });
  }
}

export async function createVehicle(req, res) {
  const { plate, brand, model, year, status, notes, branch_id } = req.body;
  try {
    const conn = await pool.getConnection();
    await conn.query(
      "INSERT INTO vehicles (plate, brand, model, year, status, notes, branch_id) VALUES (?, ?, ?, ?, ?, ?, ?)",
      [plate, brand, model, year, status, notes, branch_id || null]
    );
    res.status(201).json({ message: "Vehicle created" });
  } catch (err) {
    console.error("❌ Error creating vehicle:", err);
    res.status(500).json({ message: "Server error" });
  }
}

export async function updateVehicle(req, res) {
  const { id } = req.params;
  const { plate, brand, model, year, status, notes, branch_id } = req.body;
  try {
    const conn = await pool.getConnection();
    await conn.query(
      "UPDATE vehicles SET plate = ?, brand = ?, model = ?, year = ?, status = ?, notes = ?, branch_id = ? WHERE id = ?",
      [plate, brand, model, year, status, notes, branch_id || null, id]
    );
    res.json({ message: "Vehicle updated" });
  } catch (err) {
    console.error("❌ Error updating vehicle:", err);
    res.status(500).json({ message: "Server error" });
  }
}

export async function deleteVehicle(req, res) {
  const { id } = req.params;
  try {
    const conn = await pool.getConnection();
    await conn.query("DELETE FROM vehicles WHERE id = ?", [id]);
    res.json({ message: "Vehicle deleted" });
  } catch (err) {
    console.error("❌ Error deleting vehicle:", err);
    res.status(500).json({ message: "Server error" });
  }
}
