import db from "../db.js";

// === Λήψη όλων των items μιας μισθοδοσίας ===
export const getItemsByPayroll = async (req, res) => {
  const { payrollId } = req.params;
  try {
    const [rows] = await db.query(
      `
      SELECT 
        i.id,
        i.payroll_id,
        i.type,
        i.amount_due,
        COALESCE(SUM(p.amount), 0) AS amount_paid,
        (i.amount_due - COALESCE(SUM(p.amount), 0)) AS remaining
      FROM employee_payroll_items i
      LEFT JOIN employee_payroll_payments p ON p.item_id = i.id
      WHERE i.payroll_id = ?
      GROUP BY i.id, i.payroll_id, i.type, i.amount_due
      ORDER BY i.id ASC
      `,
      [payrollId]
    );

    res.json(rows);
  } catch (err) {
    console.error("❌ getItemsByPayroll error:", err);
    res.status(500).json({ error: "Database error" });
  }
};

// === Δημιουργία item ===
export const createItem = async (req, res) => {
  const { payrollId } = req.params;
  const { type, amount_due } = req.body;
  try {
    const [result] = await db.query(
      "INSERT INTO employee_payroll_items (payroll_id, type, amount_due, amount_paid) VALUES (?, ?, ?, 0)",
      [payrollId, type, amount_due]
    );
    res.json({ id: result.insertId, message: "Item created" });
  } catch (err) {
    console.error("❌ createItem error:", err);
    res.status(500).json({ error: "Database error" });
  }
};

// === Διαγραφή item ===
export const deleteItem = async (req, res) => {
  const { id } = req.params;
  try {
    // Διαγραφή σχετικών πληρωμών
    await db.query("DELETE FROM employee_payroll_payments WHERE item_id = ?", [id]);
    await db.query("DELETE FROM employee_payroll_items WHERE id = ?", [id]);
    res.json({ message: "Item deleted" });
  } catch (err) {
    console.error("❌ deleteItem error:", err);
    res.status(500).json({ error: "Database error" });
  }
};
