import db from "../db.js";

// === Λίστα όλων των payrolls (με φίλτρα: έτος, όνομα, περίοδος) ===
export const getPayrolls = async (req, res) => {
  try {
    const { year, name, period } = req.query;

    let sql = `
      SELECT 
        p.id,
        e.first_name,
        e.last_name,
        CONCAT(e.last_name, ' ', e.first_name) AS employee_name,
        p.period,
        p.year,
        COALESCE(SUM(i.amount_due), 0) AS total_due,
        COALESCE(SUM(i.amount_paid), 0) AS total_paid,
        (COALESCE(SUM(i.amount_due), 0) - COALESCE(SUM(i.amount_paid), 0)) AS remaining
      FROM employee_payrolls p
      LEFT JOIN employees e ON e.id = p.employee_id
      LEFT JOIN employee_payroll_items i ON i.payroll_id = p.id
      WHERE 1=1
    `;
    const params = [];

    if (year) {
      sql += " AND p.year = ?";
      params.push(year);
    }
    if (name) {
      sql += " AND (e.first_name LIKE ? OR e.last_name LIKE ?)";
      params.push(`%${name}%`, `%${name}%`);
    }
    if (period) {
      sql += " AND p.period LIKE ?";
      params.push(`%${period}%`);
    }

    sql += " GROUP BY p.id ORDER BY p.id DESC";

    const [rows] = await db.query(sql, params);
    res.json(rows);
  } catch (err) {
    console.error("❌ getPayrolls error:", err);
    res.status(500).json({ error: "Database error" });
  }
};
// === Λεπτομέρειες payroll ===
export const getPayrollDetails = async (req, res) => {
  const { id } = req.params;
  try {
    const [rows] = await db.query("SELECT * FROM payrolls WHERE id = ?", [id]);
    if (rows.length === 0) return res.status(404).json({ error: "Not found" });
    res.json(rows[0]);
  } catch (err) {
    console.error("❌ getPayrollDetails error:", err);
    res.status(500).json({ error: "Database error" });
  }
};

// === Δημιουργία payroll ===
export const createPayroll = async (req, res) => {
  try {
    const {
      employee_id,
      period,
      year,
      base_salary,
      christmas_bonus,
      easter_bonus,
      leave_allowance,
      leave_compensation,
      severance_pay,
      food_card_amount,
      bonus_total,
      overtime_total,
      paid_amount,
    } = req.body;

    const [result] = await db.query(
      `
      INSERT INTO employee_payrolls (
        employee_id, period, year, base_salary, christmas_bonus, easter_bonus,
        leave_allowance, leave_compensation, severance_pay,
        food_card_amount, bonus_total, overtime_total, paid_amount
      )
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
      `,
      [
        employee_id,
        period,
        year,
        base_salary,
        christmas_bonus,
        easter_bonus,
        leave_allowance,
        leave_compensation,
        severance_pay,
        food_card_amount,
        bonus_total,
        overtime_total,
        paid_amount,
      ]
    );

    res.json({ id: result.insertId, message: "Payroll created" });
  } catch (err) {
    console.error("❌ createPayroll error:", err);
    res.status(500).json({ error: "Database error" });
  }
};

// === Ενημέρωση payroll ===
export const updatePayroll = async (req, res) => {
  const { id } = req.params;
  try {
    const fields = Object.keys(req.body);
    const values = Object.values(req.body);
    const setClause = fields.map((f) => `${f} = ?`).join(", ");
await db.query(`UPDATE employee_payrolls SET ${setClause} WHERE id = ?`, [...values, id]);

    res.json({ message: "Payroll updated" });
  } catch (err) {
    console.error("❌ updatePayroll error:", err);
    res.status(500).json({ error: "Database error" });
  }
};

// === Διαγραφή payroll ===
export const deletePayroll = async (req, res) => {
  const { id } = req.params;
  try {
    await db.query(`
  DELETE FROM employee_payroll_payments 
  WHERE payroll_item_id IN (
    SELECT id FROM employee_payroll_items WHERE payroll_id = ?
  )
`, [id]);
await db.query("DELETE FROM employee_payroll_items WHERE payroll_id = ?", [id]);
await db.query("DELETE FROM employee_payrolls WHERE id = ?", [id]);

    res.json({ message: "Payroll deleted" });
  } catch (err) {
    console.error("❌ deletePayroll error:", err);
    res.status(500).json({ error: "Database error" });
  }
};
