import db from "../db.js";

export const getApprovers = async (req, res) => {
  try {
    const [rows] = await db.execute(`
      SELECT a.*, u.username, b.name AS branch_name
      FROM leave_approvers a
      JOIN users u ON a.approver_user_id = u.id
      JOIN branches b ON a.branch_id = b.id
      ORDER BY a.branch_id, a.level
    `);
    res.json(rows);
  } catch (err) {
    console.error("getApprovers error:", err);
    res.status(500).json({ message: "Σφάλμα κατά την ανάκτηση." });
  }
};

export const createApprover = async (req, res) => {
  const { branch_id, level, approver_user_id } = req.body;

  try {
    await db.execute(
      `INSERT INTO leave_approvers (branch_id, level, approver_user_id) VALUES (?, ?, ?)`,
      [branch_id, level, approver_user_id]
    );
    res.status(201).json({ message: "Ο εγκριτής καταχωρήθηκε." });
  } catch (err) {
    console.error("createApprover error:", err);
    res.status(500).json({ message: "Σφάλμα καταχώρισης." });
  }
};

export const deleteApprover = async (req, res) => {
  const { id } = req.params;
  try {
    await db.execute(`DELETE FROM leave_approvers WHERE id = ?`, [id]);
    res.json({ message: "Ο εγκριτής διαγράφηκε." });
  } catch (err) {
    console.error("deleteApprover error:", err);
    res.status(500).json({ message: "Σφάλμα διαγραφής." });
  }
};
