import db from "../db.js";
import fs from "fs";
import path from "path";

const uploadDir = "uploads/employee_files";

// 📥 Δημιουργία αρχείου
export const createEmployeeFile = async (req, res) => {
  try {
    const { employee_id, file_type } = req.body;
    const filename = req.file?.filename;

    if (!filename) {
      return res.status(400).json({ message: "No file uploaded" });
    }

    await db.query(
      `INSERT INTO employee_files (employee_id, file_type, filename) VALUES (?, ?, ?)`,
      [employee_id, file_type, filename]
    );

    res.json({ message: "File uploaded successfully" });
  } catch (err) {
    console.error("❌ Error uploading file:", err);
    res.status(500).json({ message: "Database error: " + err.message });
  }
};

// 📃 Ανάγνωση αρχείων υπαλλήλου
export const getEmployeeFiles = async (req, res) => {
  try {
    const [rows] = await db.query(
      `SELECT * FROM employee_files WHERE employee_id = ? ORDER BY uploaded_at DESC`,
      [req.params.employeeId]
    );
    res.json(rows);
  } catch (err) {
    console.error("❌ Error fetching files:", err);
    res.status(500).json({ message: "Database error: " + err.message });
  }
};

// 🗑️ Διαγραφή αρχείου
export const deleteEmployeeFile = async (req, res) => {
  try {
    const [rows] = await db.query(
      "SELECT filename FROM employee_files WHERE id = ?",
      [req.params.id]
    );

    if (!rows.length) {
      return res.status(404).json({ message: "File not found" });
    }

    const filePath = path.join(uploadDir, rows[0].filename);
    if (fs.existsSync(filePath)) fs.unlinkSync(filePath);

    await db.query("DELETE FROM employee_files WHERE id = ?", [req.params.id]);
    res.json({ message: "File deleted successfully" });
  } catch (err) {
    console.error("❌ Error deleting file:", err);
    res.status(500).json({ message: "Database error: " + err.message });
  }
};
