import db from "../db.js";

// === Get all employees ===
export const getEmployees = async (req, res) => {
  try {
    const [rows] = await db.query(`
      SELECT 
        id,
        user_id,
        branch_id,
        first_name,
        last_name,
        position,
        department,
        hire_date,
        termination_date,
        salary,
        employment_type,
        employment_status,
        iban,
        afm,
        amka,
        phone,
        address,
        emergency_contact,
        notes
      FROM employees
      ORDER BY last_name ASC, first_name ASC
    `);
    res.json(rows);
  } catch (err) {
    console.error("❌ Error fetching employees:", err);
    res.status(500).json({ message: err.message });
  }
};

// === Get one employee by ID ===
export const getEmployeeById = async (req, res) => {
  try {
    const [rows] = await db.query("SELECT * FROM employees WHERE id = ?", [req.params.id]);
    if (rows.length === 0) return res.status(404).json({ message: "Employee not found" });
    res.json(rows[0]);
  } catch (err) {
    console.error("❌ Error fetching employee:", err);
    res.status(500).json({ message: err.message });
  }
};

// === Create employee ===
export const createEmployee = async (req, res) => {
  try {
    const {
      user_id,
      branch_id,
      first_name,
      last_name,
      position,
      department,
      hire_date,
      termination_date,
      salary,
      employment_type,
      employment_status,
      iban,
      afm,
      amka,
      phone,
      address,
      emergency_contact,
      notes,
    } = req.body;

    await db.query(
      `INSERT INTO employees (
        user_id, branch_id, first_name, last_name, position, department,
        hire_date, termination_date, salary, employment_type, employment_status,
        iban, afm, amka, phone, address, emergency_contact, notes
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
      [
        user_id,
        branch_id,
        first_name,
        last_name,
        position,
        department,
        hire_date,
        termination_date,
        salary,
        employment_type,
        employment_status,
        iban,
        afm,
        amka,
        phone,
        address,
        emergency_contact,
        notes,
      ]
    );

    res.json({ message: "✅ Υπάλληλος δημιουργήθηκε επιτυχώς." });
  } catch (err) {
    console.error("❌ Error creating employee:", err);
    res.status(500).json({ message: err.message });
  }
};

// === Update employee ===
export const updateEmployee = async (req, res) => {
  try {
    const {
      branch_id,
      first_name,
      last_name,
      position,
      department,
      hire_date,
      termination_date,
      salary,
      employment_type,
      employment_status,
      iban,
      afm,
      amka,
      phone,
      address,
      emergency_contact,
      notes,
    } = req.body;

    await db.query(
      `UPDATE employees SET
        branch_id = ?, first_name = ?, last_name = ?, position = ?, department = ?,
        hire_date = ?, termination_date = ?, salary = ?, employment_type = ?, employment_status = ?,
        iban = ?, afm = ?, amka = ?, phone = ?, address = ?, emergency_contact = ?, notes = ?
      WHERE id = ?`,
      [
        branch_id,
        first_name,
        last_name,
        position,
        department,
        hire_date,
        termination_date,
        salary,
        employment_type,
        employment_status,
        iban,
        afm,
        amka,
        phone,
        address,
        emergency_contact,
        notes,
        req.params.id,
      ]
    );

    res.json({ message: "✅ Υπάλληλος ενημερώθηκε επιτυχώς." });
  } catch (err) {
    console.error("❌ Error updating employee:", err);
    res.status(500).json({ message: err.message });
  }
};

// === Delete employee ===
export const deleteEmployee = async (req, res) => {
  try {
    await db.query("DELETE FROM employees WHERE id = ?", [req.params.id]);
    res.json({ message: "🗑️ Υπάλληλος διαγράφηκε επιτυχώς." });
  } catch (err) {
    console.error("❌ Error deleting employee:", err);
    res.status(500).json({ message: err.message });
  }
};
